/**
 * Fecha de creacin: (17/11/2010)
 */   
package com.ejie.p06b.pdf;

import javax.servlet.http.HttpServletRequest;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.pdf.xml.P06BInformeOtroResumenDECXML;
import com.ejie.p06b.util.P06BParametros;
import com.ejie.p06b.xlnet.P06BPerfilUsuario;


/**
 * Clase que gestiona la generacin del pdf
 */
public class P06BInformeOtroResumenDECPDF implements P06BIPDF{
    private static long numeroPDF = 0;
	
	public String getXmlPdf(HttpServletRequest request){
    	String xmlPdf = null;
    	try {
			//Obtenemos el XML haciendo selects que calculen los datos a mostrar
			P06BLog.send(2,this.getClass().getName()+ " - getXmlPdf", "Antes de obtener el XML de datos");
			xmlPdf = P06BInformeOtroResumenDECXML.getXml(request);
			P06BLog.send(2,this.getClass().getName()+ " - getXmlPdf", "Despues de obtener el XML de datos");
    	}catch( Exception e) {
			P06BLog.send(2,this.getClass().getName()+ " - getXmlPdf", "Error al obtener el XML: " + e.getMessage());
			return null;
		}
    	
		return xmlPdf;
    }
    
    public String getXsltFichero(HttpServletRequest request){
    	String xsltFichero = null;
    	try {
			//Obtener el idioma
			String idioma = null;
			P06BPerfilUsuario perfilUsuario = (P06BPerfilUsuario) request.getSession().getAttribute(P06BConstantes.P06B_VAR_PERFIL_USUARIO);
			if (perfilUsuario != null){
				P06BLog.send(2,this.getClass().getName() + " - getXsltFichero", "Existe objeto perfilUsuario");
				idioma = perfilUsuario.getIdIdioma();
			}else{
				P06BLog.send(2,this.getClass().getName() + " - getXsltFichero", "NOOOOOO Existe objeto perfilUsuario");
			}
			if (idioma == null || idioma.equals("") ){
				idioma = P06BConstantes.P06B_IDIOMA_ES; //"es"
			}
			P06BLog.send(2,this.getClass().getName() + " - getXsltFichero", "Idioma: "+idioma);
			
			//De momento solo est en castellano
			xsltFichero = P06BParametros.getListado("pdf.xsl.informeOtroResumenDEC_es");
			
    	}catch( Exception e) {
			P06BLog.send(2,this.getClass().getName() + " - getXsltFichero", "Error al obtener el nombre del xslt: " + e.getMessage());
			return null;
		}
    	return xsltFichero;
    }
	
}